% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Negative_Binomial.R
\name{liknbinom}
\alias{liknbinom}
\title{Negative Binomial Log Likelihood Function}
\usage{
liknbinom(x, size, prob, mu, log = TRUE)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{size}{target for number of successful trials, or dispersion
    parameter (the shape parameter of the gamma mixing distribution).
    Must be strictly positive, need not be integer.}

\item{prob}{probability of success in each trial. \code{0 < prob <= 1}.}

\item{mu}{alternative parametrization via mean: see \sQuote{Details}.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
A numeric scalar for the log likelihood of the negative binomial
density given the data where size, prob, and mu can be held constant or if
vector were given vector will be returned.
}
\description{
The log likelihood of a negative binomial density with data, x, size, prob
and mu parameters.
}
\details{
The log likelihood is the log of a function of parameters given the data.
}
\examples{
liknbinom(x = rnbinom(n = 2, size = 3, prob = .4),
        size = 3, prob = .4)
}
