% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_logistic_regress.R
\name{L_logistic_regress}
\alias{L_logistic_regress}
\title{Likelihood Support for Logistic Regression}
\usage{
L_logistic_regress(yv, p1, p2=NULL, p3=NULL, p4=NULL, p5=NULL, p6=NULL, verb=TRUE)
}
\arguments{
\item{yv}{a binomial numeric vector for dependent variable.}

\item{p1}{vector for predictor variable, same length as yv.}

\item{p2}{vector for predictor variable, same length as yv, default = NULL.}

\item{p3}{vector for predictor variable, same length as yv, default = NULL.}

\item{p4}{vector for predictor variable, same length as yv, default = NULL.}

\item{p5}{vector for predictor variable, same length as yv, default = NULL.}

\item{p6}{vector for predictor variable, same length as yv, default = NULL.}

\item{verb}{show output, default = TRUE.}
}
\value{
$S.FNc - support for the full versus null (constant value) model.

$S.each - support for each of the predictors, from first to last.

$chi.sq.FN - chi-squared for full versus null model.

$df - degrees of freedom for chi-squared.

$chi.sq.FN.p - p value for chi-squared.

$p.vals - p values for each of the predictors
}
\description{
This function calculates the supports for multiple logistic regression.
A binary dependent variable is entered into the function, followed by up to 6 predictor
variables (which need to be dummy coded if nominal and more than 2 levels). Outputs
give the overall support for the full model versus the null (constant) model, supports
for each of the predictor variables. Outputs include the usual chi-squared and p values.
}
\examples{
# prescription errors example, p 114
p_error <- c(rep(1,6),rep(0,9))
score <- c(4,	5,	6,	5,	4,	6,	6,	4,
5,	8,	9,	7,	10,	8,	9)
med1 <- c(1,	1,	0,	0,	1,	1,	0,	0,
0,	0,	0,	0,	0,	0,	1)
med2 <- c(0,	0,	1,	0,	0,	0,	1,	0,
0,	1,	1,	0,	1,	1,	0)
m1 = L_logistic_regress(p_error, score, med1, med2)
m1

}
\references{
Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

1 Akaike H. A new look at the statistical model identification. IEEE Transactions
on Automatic Control. 1974;19(6):716.

Glover S, Dixon P. Likelihood ratios: a simple and flexible statistic for empirical
psychologists. Psychonomic Bulletin & Review. 2004;11(5):791.

Tabachnick BG, Fidell LS. Using Multivariate Statistics. Boston: Pearson Education; 2007.
}
\keyword{Likelihood;}
\keyword{logistic}
\keyword{regression}
\keyword{support;}
