% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signals.R
\name{signals}
\alias{signals}
\title{Get Signals Data}
\usage{
signals(
  vendor = "boosted",
  model = "50678d2d-fd0f-4841-aaee-7feac83cb3a1",
  symbol = "AAPL",
  from = "2010-01-01",
  to = Sys.Date()
)
}
\arguments{
\item{vendor}{The vendor name associated with the signals data.}

\item{model}{The model identifier for which signals data is requested.}

\item{symbol}{The stock symbol for which signals data is requested.}

\item{from}{The start date for the signals data retrieval in 'YYYY-MM-DD' format.}

\item{to}{The end date for the signals data retrieval in 'YYYY-MM-DD' format.}
}
\value{
A data frame containing the signals data if the request is successful; NULL otherwise.
}
\description{
Retrieves signals data for a specified stock symbol and model from the Limex API.
The function uses the API token that is stored in the 'LIMEX_API_TOKEN' environment variable.
}
\examples{
\dontrun{
  signals_data <- signals(vendor = "boosted", symbol = "AAPL")
}
}
