% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_reshist.R
\name{gg_reshist}
\alias{gg_reshist}
\title{Generate histogram of residuals in ggplot.}
\usage{
gg_reshist(fitted.lm, bins = NULL)
}
\arguments{
\item{fitted.lm}{a fitted linear model (i.e. lm, glm) that contains fitted regression}

\item{bins}{bin size for histogram}
}
\value{
A ggplot object
}
\description{
Generate histogram of residuals in ggplot.
}
\examples{
library(MASS)
data(Cars93)
cars_lm <- lm(Price~ Passengers + Length + RPM, data = Cars93)
gg_reshist(cars_lm)
# specify number of bins
gg_reshist(cars_lm, bins = 20)
}
