% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{dominguez_lobato_test}
\alias{dominguez_lobato_test}
\title{Tests the specification of a linear model using wild-bootstrap.}
\usage{
dominguez_lobato_test(
  model,
  distribution = "rnorm",
  statistic = "cvm_value",
  times = 300,
  quantiles = c(0.9, 0.95, 0.99),
  verbose = FALSE,
  n_cores = 1
)
}
\arguments{
\item{model}{An existing fit from a model function such as `lm`, `lfe` and others
compatible with `update`.}

\item{distribution}{Type of noise added to residuals, ej `rnorm` or `rrademacher`.}

\item{statistic}{Type of statistic to be used, can be one of `cvm_value` or `kmv_value`.}

\item{times}{Number of bootstrap samples.}

\item{quantiles}{Vector of quantiles to calculate pvalues.}

\item{verbose}{TRUE to print each bootstrap iteration.}

\item{n_cores}{Number of cores to be used.}
}
\value{
A list with dataframe results and the ordered values of each bootstrap iteration.
}
\description{
Tests the specification of a linear model using wild-bootstrap.
}
\examples{

x <- 1:10 + rnorm(10)
y <- 1:10
model <- lm(y~x)
dl_test <- dominguez_lobato_test(model)
dl_test <- dominguez_lobato_test(model, distribution = "rmammen_point", statistic = "kmv_value")
dl_test <- dominguez_lobato_test(model, times = 100)
}
\references{
Manuel A. Dominguez and Ignacio N. Lobato (2019).
Specification Testing with Estimated Variables. Econometric Reviews.
}
