% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{logLikNB}
\alias{logLikNB}
\title{Compute Log-Likelihood for a Right-Truncated Negative Binomial Model}
\usage{
logLikNB(delay_vec, x12, disp, betaplus, maxdelay)
}
\arguments{
\item{delay_vec}{NumericVector representing the observed delay times for each case.}

\item{x12}{NumericMatrix of covariates used to model the mean of the negative binomial distribution.
Each row corresponds to a case and columns correspond to covariates including time since onset and others.}

\item{disp}{NumericVector indicating the dispersion parameter for each case. This can affect the distribution 
of counts and is used to model heterogeneity in reporting delays.}

\item{betaplus}{NumericVector containing current estimates of the model parameters, which may include 
coefficients for covariates and additional parameters.}

\item{maxdelay}{Integer specifying the maximum reporting delay, truncating the distribution at this value.}
}
\value{
Double representing the log-likelihood of the data given the model parameters. This value 
        measures how well the model with the current parameter estimates fits the observed data.
}
\description{
This function calculates the log-likelihood of observing the given data under a 
right-truncated negative binomial distribution. It is used to assess the fit of 
a model involving delay times in reporting cases, where each case has a 
delay modeled by a negative binomial distribution that is truncated at a specified maximum delay.
}
\details{
This function computes the log-likelihood by calculating the likelihood of each observed 
         delay under the specified model parameters, considering the truncation at `maxdelay`. 
         The parameters `disp` and `betaplus` allow for flexibility in modeling different types of 
         heterogeneity and covariate effects.
}
\examples{
# Example usage with arbitrary data:
delay_vec <- rnorm(100, mean=10, sd=3)  # Simulated delay times
x12 <- matrix(rnorm(300), ncol=3)       # Simulated covariates
disp <- rep(1, 100)                     # Dispersion parameter, constant for simplicity
betaplus <- runif(4)                    # Simulated parameter estimates
maxdelay <- 15                          # Maximum delay for truncation
loglik_value <- logLikNB(delay_vec, x12, disp, betaplus, maxdelay)
}
