% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corCouplesToMatrix.R
\name{corCouplesToMatrix}
\alias{corCouplesToMatrix}
\title{Couples to matrix}
\usage{
corCouplesToMatrix(x1_x2_val)
}
\arguments{
\item{x1_x2_val}{a specific dataframe containing correlations values resulting from
the function multiBivariateCorrelation() and containing only one coefficient type.}
}
\value{
a dataframe corresponding to a correlation matrix.
}
\description{
Transform a 2 column correlation dataframe into a correlation matrix
}
\examples{
# calculate a correlation dataframe
data(iris)
corDF<-multiBivariateCorrelation(dataset = iris, corMethods = "MaxNMI")
corMatrix<-corCouplesToMatrix(x1_x2_val = corDF[,c('X1','X2',"MaxNMI")])
print(corMatrix)
corCouples<-matrixToCorCouples(corMatrix,coefName="pearson")
print(corCouples)

}
