% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_bind.R
\name{list_bind_all}
\alias{list_bind_all}
\title{Bind all elements together and extract them.}
\usage{
list_bind_all(in_list, what = "rows")
}
\arguments{
\item{in_list}{The list to work on.}

\item{what}{Either 'rows' or 'cols'}
}
\value{
All elements in the list bound together.
}
\description{
Bind all elements together and extract them.
}
\details{
This a convenient wrapper around `list_bind` which selects
everything in the list and extracts the result.
}
\examples{
dfl <- list(data.frame(idx = 1:20, y = rnorm(20)),
            data.frame(idx = 21:40, y = rnorm(20)),
            data.frame(idx = 41:60, y = rnorm(20)))
list_bind_all(dfl)
}
