% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap_parameters}
\alias{bootstrap_parameters}
\title{Create a bootstrap distribution of a particular coefficient from a model fit}
\usage{
bootstrap_parameters(x,nboot,upper,lower,...)
}
\arguments{
\item{x}{an object of class "\code{litfit}"}

\item{nboot}{number of bootstrap replications}

\item{upper}{optional vector of upper bounds for the bootstrap replicates}

\item{lower}{optional vector of lower bounds for the bootstrap replicates}

\item{...}{passed to \code{\link{optim}}}
}
\value{
litfit_bootstrap object
}
\description{
Create a bootstrap distribution of a particular coefficient from a model fit
}
\examples{
fit <- fit_litter(time=pineneedles$Year,
mass.remaining=pineneedles$Mass.remaining, model='neg.exp', iters=100)
boot1 <- bootstrap_parameters(fit, nboot = 500)



}
