% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{model_selection}
\alias{model_selection}
\title{Model selections for \code{lnmbicluster}}
\usage{
model_selection(W_count, range_G, range_Q, model, permutation, iter, const, X)
}
\arguments{
\item{W_count}{The microbiome count matrix that you want to analyze.}

\item{range_G}{All possible number of component groups, a vector.}

\item{range_Q}{All possible number of bicluster groups Q, a vector.}

\item{model}{A vector of string that contain cov_str you want to select. Default is all 16 models.}

\item{permutation}{Only has effect when model contains UUU, UUG, UUD or UUC. If TRUE,
it assume the number of biclusters could be different for different components. If FALSE,
it assume the number of biclusters are the same cross all components.}

\item{iter}{Max iterations, defaul is 150.}

\item{const}{Constant permutation term in multinomial distribution.}

\item{X}{The regression covariates matrix, which generates from model.matrix.}
}
\value{
A dataframe that contain the cov_str, K, Q, AIC, BIC, ICL values for model. There may
be a lot rows if large K and Q, because of lots of combinations: it is a sum of a geometric
series with multiplier max(Q) from 1 to max(K).
}
\description{
fit several models for lnmbicluster along with 3 criteria values: AIC BIC and ICL
}
