% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_lscore.R
\name{summary.lscore}
\alias{summary.lscore}
\title{Summary of Load Shape Score}
\usage{
\method{summary}{lscore}(object, ... = NULL)
}
\arguments{
\item{object}{An object of class \code{lscore},
created by the function \code{\link{lscore}}.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
\code{NULL}. Prints the summary of the load shape score.
}
\description{
Summary method of \code{lscore} object
}
\note{
Same as \code{\link{print.lscore}}
}
\examples{
loads <- ercot[ercot$Year == 2019, ]$SOUTH
# --------------
log_loadshape <- lslog(loads, target_lf = 0.5)
summary(lscore(log_loadshape, type = "acf"))
summary(lscore(log_loadshape, type = "pacf"))
# --------------
lin_loadshape <- lslin(loads, target_lf = 0.5)
summary(lscore(lin_loadshape, type = "acf"))
summary(lscore(lin_loadshape, type = "pacf"))


}
\seealso{
\code{\link{lslin}}, \code{\link{lslog}},
\code{\link{lscore}}
}
