% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers_non_base.R
\name{debuginfo}
\alias{debuginfo}
\title{Debug Log Handler}
\usage{
debuginfo(..., call. = TRUE, .loggit = NA, echo = get_echo())
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or a single
    condition object.}

\item{call.}{logical, indicating if the call should become part of the
    warning message.}

\item{.loggit}{Should the condition message be added to the log?
If \code{NA} the log level set by \code{set_log_level()} is used to determine if the condition should be logged.}

\item{echo}{Should the log entry (json) be echoed to \code{stdout} as well?}
}
\value{
No return value.
}
\description{
This function works like base R's \code{\link[base:warning]{warning}} ,
but is silent, includes logging of the exception message via \code{loggit()} and does not allow conditions as input.
}
\details{
This function is more than just a wrapper around \code{loggit()} with a log level of "DEBUG".
It has the ability to track the call stack and log it if \code{call.} is set to \code{TRUE} and to automatically
translate the input into a message using \code{.makeMessage()}, like \code{warning()} does.
}
\examples{
\dontrun{
  debuginfo("This is a completely false condition")

  debuginfo("This is a completely false condition", echo = FALSE)
}

}
\seealso{
Other handlers: 
\code{\link{message}()},
\code{\link{stop}()},
\code{\link{stopifnot}()},
\code{\link{warning}()}
}
\concept{handlers}
