% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{stopifnot}
\alias{stopifnot}
\title{Conditional Stop Log Handler}
\usage{
stopifnot(..., exprs, exprObject, local, .loggit = NA, echo = get_echo())
}
\arguments{
\item{..., exprs}{any number of \code{R} expressions, which should each evaluate to (a logical vector of all) \code{TRUE}.
Use \emph{either} \code{...} \emph{or} \code{exprs}, the latter typically an unevaluated expression of the form

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{
  expr1
  expr2
  ....
\}
}\if{html}{\out{</div>}}

Note that e.g., positive numbers are not \code{TRUE}, even when they are coerced to \code{TRUE}, e.g., inside \verb{if(.)} or
in arithmetic computations in \code{R}.
If names are provided to \code{...}, they will be used in lieu of the default error message.}

\item{exprObject}{alternative to \code{exprs} or \code{...}:
    an \sQuote{expression-like} object, typically an
    \code{\link[base]{expression}}, but also a \code{\link[base]{call}}, a
    \code{\link[base]{name}}, or atomic constant such as \code{TRUE}.
  }

\item{local}{(only when \code{exprs} is used:) indicates the
    \code{\link[base]{environment}} in which the expressions should be
    evaluated; by default the one from where \code{stopifnot()} has been
    called.}

\item{.loggit}{Should the condition message be added to the log?
If \code{NA} the log level set by \code{set_log_level()} is used to determine if the condition should be logged.}

\item{echo}{Should the log entry (json) be echoed to \code{stdout} as well?}
}
\description{
This function is identical to base R's \code{\link[base:stopifnot]{stopifnot}},
but it includes logging of the exception message via \code{loggit()}.
}
\examples{
\dontrun{
 stopifnot("This is a completely false condition" = FALSE)

 stopifnot(5L == 5L, "This is a completely false condition" = FALSE, echo = FALSE)
}

}
\seealso{
Other handlers: 
\code{\link{debuginfo}()},
\code{\link{message}()},
\code{\link{stop}()},
\code{\link{warning}()}
}
\concept{handlers}
