% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{get_clusters}
\alias{get_clusters}
\title{Extract the cluster assignments}
\usage{
get_clusters(cluster_solution, number_clusters = NULL)
}
\arguments{
\item{cluster_solution}{an \code{lcc} object}

\item{number_clusters}{default is \code{NULL} to return all assignments.
Otherwise specify a numeric vector with the number of clusters for which the
assignments should be returned, e.g. \code{2:4}}
}
\value{
a \code{data.frame} with an ID column (the name of the ID column
was specified by the user when calling the
\code{longitudinal_consensus_cluster}) function and one column with cluster
assignments for every specified number of clusters. Only the assignments
included in \code{number_clusters} are returned in the form of columns with
the names \code{assignment_num_clus_x}
}
\description{
This functions extracts the cluster assignments from an \code{lcc} object.
One can specify which for which number of clusters the assignments
should be returned.
}
\examples{
# not run
set.seed(5)
test_data <- data.frame(patient_id = rep(1:10, each = 4),
visit = rep(1:4, 10),
var_1 = c(rnorm(20, -1), rnorm(20, 3)) +
rep(seq(from = 0, to = 1.5, length.out = 4), 10),
var_2 = c(rnorm(20, 0.5, 1.5), rnorm(20, -2, 0.3)) +
rep(seq(from = 1.5, to = 0, length.out = 4), 10))
model_list <- list(flexmix::FLXMRmgcv(as.formula("var_1 ~ .")),
flexmix::FLXMRmgcv(as.formula("var_2 ~ .")))
clustering <- longitudinal_consensus_cluster(
data = test_data,
id_column = "patient_id",
max_k = 2,
reps = 3,
model_list = model_list,
flexmix_formula = as.formula("~s(visit, k = 4) | patient_id"))
cluster_assignments <- get_clusters(clustering, number_clusters = 2)
# end not run
}
