% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpcde_methods.R
\name{vcov.lpcde}
\alias{vcov.lpcde}
\title{Variance-Covariance}
\usage{
\method{vcov}{lpcde}(object, ...)
}
\arguments{
\item{object}{Class "lpdensity" object, obtained by calling \code{\link{lpcde}}.}

\item{...}{Additional options.}
}
\value{
\item{stdErr}{A matrix containing grid points and standard errors using p- and q-th order local polynomials.}
\item{CovMat}{The variance-covariance matrix corresponding to \code{est}.}
\item{CovMat_RBC}{The variance-covariance matrix corresponding to \code{est_RBC}.}
}
\description{
The vcov method for local polynomial conditional density objects.
}
\details{
Vcov method for local polynomial density conditional estimation
}
\examples{
n <- 100
x_data <- as.matrix(rnorm(n, mean = 0, sd = 1))
y_data <- as.matrix(rnorm(n, mean = 0, sd = 1))
y_grid <- stats::quantile(y_data, seq(from = 0.1, to = 0.9, by = 0.1))
# density estimation
model1 <- lpcde::lpcde(x_data = x_data, y_data = y_data, y_grid = y_grid, x = 0, bw = 0.5)
vcov(model1)

}
\seealso{
\code{\link{lpcde}} for local polynomial conditional density estimation.

Supported methods: \code{\link{plot.lpcde}}, \code{\link{print.lpcde}},
\code{\link{summary.lpcde}},
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Rajita Chandak (maintainer), Princeton University. \email{rchandak@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma, University of California San Diego. \email{x1ma@ucsd.edu}.
}
