% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmvnorm}
\alias{rmvnorm}
\title{Random Multivariate Normal Generation}
\usage{
rmvnorm(n, mean, sigma)
}
\arguments{
\item{n}{The number of samples to generate.}

\item{mean}{A numeric vector representing the mean of the distribution.}

\item{sigma}{A numeric matrix representing the covariance matrix.}
}
\value{
A numeric matrix where each row represents a sample from the
multivariate normal distribution.
}
\description{
Generates random samples from a multivariate normal
distribution with a specified mean vector and covariance matrix.
}
\details{
This function generates samples from a multivariate normal distribution
using the Cholesky decomposition method. It first computes the Cholesky
factorization of the covariance matrix, then generates standard normal
random variables, and finally transforms them to the desired multivariate
normal distribution.
}
\examples{
# Generate 5 samples from a bivariate normal distribution with mean (0,0)
# and covariance matrix [[1, 0.5], [0.5, 1]]

set.seed(314159)
rmvnorm(5, c(0, 0), matrix(c(1, 0.5, 0.5, 1), nrow=2))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
