% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette_find.R
\name{palette_find}
\alias{palette_find}
\title{Find a Long Term Ecological Research (LTER) Site-Derived Palette}
\usage{
palette_find(site = "all", name = "all", type = "all")
}
\arguments{
\item{site}{(character) Vector of three-letter LTER site abbreviations for which to return palettes or "all" or "LTER" for the LTER logo colors}

\item{name}{(character) Vector of palette names (if known) for which to return palettes}

\item{type}{(character) Vector of palette types (i.e., qualitative, tricolor, sequential, or diverging) for which to return palettes}
}
\value{
(dataframe / character) If more than one palette, a dataframe is returned; if exactly one palette, a character vector is returned
}
\description{
From a dataframe of all possible palettes (updated periodically so check back!) specify the characteristics of the palette you want and retrieve the palettes that match those criteria. Can specify by number of colors in the palette, type of palette (e.g., qualitative, sequential, etc.), or which LTER site the palette came from.
}
\examples{
# Look at all palette options by calling the function without specifying arguments
lterpalettefinder::palette_find()

# What if our query returns NO options?
palette_find(name = "no such name")

# What if our query returns MULTIPLE options?
palette_find(site = "sbc")

# What if our query returns JUST ONE option? (this is desirable)
palette_find(name = "salamander")

}
