% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lunar.package.R
\name{lunar.illumination.mean}
\alias{lunar.illumination.mean}
\title{Average Lunar Illumination}
\usage{
lunar.illumination.mean(
  x,
  towards = -6,
  ...,
  by = c("date", "hours", "day", "night")
)
}
\arguments{
\item{x}{A vector of \code{\link[base]{Date}} values.}

\item{towards}{The directed window size from \code{x} in days.
By default the window looks back 7 days including \code{x}.}

\item{...}{Other optional arguments are ignored.}

\item{by}{The exposure interval and integration basis.
The default is to represent a day's illumination by
the illumination at 12 noon UT.  The other options integrate
midrange illuminations over hours.  Options 'day' and 'night'
are not currently implemented, but will be used to limit
exposure intervals.
The use of an unimplemented option
in a function call will result in a \code{NULL} value
being returned.}
}
\description{
Returns the average lunar illumination around specified dates.
}
\examples{
lunar.illumination.mean(as.Date("2004-03-24"))
}
\seealso{
\code{\link{lunar.illumination}}
}
\keyword{illumination}
\keyword{light}
\keyword{lunar}
\keyword{moon}
