% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks-monitor-metrics.R
\name{luz_callback_keep_best_model}
\alias{luz_callback_keep_best_model}
\title{Keep the best model}
\usage{
luz_callback_keep_best_model(
  monitor = "valid_loss",
  mode = "min",
  min_delta = 0
)
}
\arguments{
\item{monitor}{A string in the format \verb{<set>_<metric>} where \verb{<set>} can be
'train' or 'valid' and \verb{<metric>} can be the abbreviation of any metric
that you are tracking during training. The metric name is case insensitive.}

\item{mode}{Specifies the direction that is considered an improvement. By default
'min' is used. Can also be 'max' (higher is better) and 'zero'
(closer to zero is better).}

\item{min_delta}{Minimum improvement to reset the patience counter.}
}
\description{
Each epoch, if there's improvement in the monitored metric we serialize the
model weights to a temp file. When training is done, we reload weights from
the best model.
}
\examples{
cb <- luz_callback_keep_best_model()

}
\seealso{
Other luz_callbacks: 
\code{\link{luz_callback}()},
\code{\link{luz_callback_auto_resume}()},
\code{\link{luz_callback_csv_logger}()},
\code{\link{luz_callback_early_stopping}()},
\code{\link{luz_callback_interrupt}()},
\code{\link{luz_callback_lr_scheduler}()},
\code{\link{luz_callback_metrics}()},
\code{\link{luz_callback_mixed_precision}()},
\code{\link{luz_callback_mixup}()},
\code{\link{luz_callback_model_checkpoint}()},
\code{\link{luz_callback_profile}()},
\code{\link{luz_callback_progress}()},
\code{\link{luz_callback_resume_from_checkpoint}()},
\code{\link{luz_callback_train_valid}()}
}
\concept{luz_callbacks}
