% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lvim_autc.R
\name{lvim_autc}
\alias{lvim_autc}
\title{Area Under the Variable Importance Trajectory}
\usage{
lvim_autc(
  lvim,
  indices = 1:length(lvim),
  interpolator = "linear",
  delta = 0,
  ...
)
}
\arguments{
\item{lvim}{an object of class \code{lvim} containing the cross-sectional
variable importance objects}

\item{indices}{a numeric vector indicating the contiguous subset of the
time series}

\item{interpolator}{a string indicating the type of interpolator used to
take the area under the trajectory}

\item{delta}{null hypothesis value}

\item{...}{other arguments to be passed to the interpolator function}
}
\value{
The \code{lvim} object, with point estimates, CIs, and p-values
  related to the area under the trend in variable importance filled in.
}
\description{
Compute a nonparametric estimate of (and efficient influence function for) the
area under the longitudinal variable importance trajectory (AUTC) over a contiguous subset of the time series.
}
