% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-lv.r, R/stat-lv.r
\docType{data}
\name{geom_lv}
\alias{geom_lv}
\alias{GeomLv}
\alias{scale_fill_lv}
\alias{stat_lv}
\alias{StatLv}
\title{Side-by-side LV boxplots with ggplot2.}
\format{
An object of class \code{GeomLv} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 6.

An object of class \code{StatLv} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 5.
}
\usage{
geom_lv(
  mapping = NULL,
  data = NULL,
  stat = "lv",
  position = "dodge",
  outlier.colour = "black",
  outlier.shape = 19,
  outlier.size = 1.5,
  outlier.stroke = 0.5,
  na.rm = TRUE,
  varwidth = FALSE,
  width.method = "linear",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

GeomLv

scale_fill_lv(...)

stat_lv(
  mapping = NULL,
  data = NULL,
  geom = "lv",
  position = "dodge",
  na.rm = TRUE,
  conf = 0.95,
  percent = NULL,
  k = NULL,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

StatLv
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{outlier.colour}{Override aesthetics used for the outliers. Defaults
come from \code{geom_point()}.}

\item{outlier.shape}{Override aesthetics used for the outliers. Defaults
come from \code{geom_point()}.}

\item{outlier.size}{Override aesthetics used for the outliers. Defaults
come from \code{geom_point()}.}

\item{outlier.stroke}{Override aesthetics used for the outliers. Defaults
come from \code{geom_point()}.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{varwidth}{if \code{FALSE} (default) draw boxes that are the same size for each group. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{width.method}{character, one of 'linear' (default), 'area', or 'height'. This parameter
determines whether the width of the box for letter value \code{LV(i)} should be proportional to i (linear), 
proportional to \eqn{2^{-i}} (height), or whether the area of the box should be proportional to \eqn{2^{-i}} (area).}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{geom, stat}{Use to override the default connection between
\code{geom_lv} and \code{stat_lv}.}

\item{conf}{confidence level}

\item{percent}{numeric value: percent of data in outliers}

\item{k}{number of letter values shown}
}
\description{
An extension of standard boxplots which draws k letter statistics.
Conventional boxplots (Tukey 1977) are useful displays for conveying rough
information about the central 50\% of the data and the extent of the data.
For moderate-sized data sets (\eqn{n < 1000}), detailed estimates of tail
behavior beyond the quartiles may not be trustworthy, so the information
provided by boxplots is appropriately somewhat vague beyond the quartiles,
and the expected number of ``outliers'' and ``far-out'' values for a
Gaussian sample of size \eqn{n} is often less than 10 (Hoaglin, Iglewicz,
and Tukey 1986). Large data sets (\eqn{n \approx 10,000-100,000}) afford
more precise estimates of quantiles in the tails beyond the quartiles and
also can be expected to present a large number of ``outliers'' (about
\eqn{0.4 + 0.007 n}).
The letter-value box plot addresses both these shortcomings: it conveys
more detailed information in the tails using letter values, only out to the
depths where the letter values are reliable estimates of their
corresponding quantiles (corresponding to tail areas of roughly
\eqn{2^{-i}}); ``outliers'' are defined as a function of the most extreme
letter value shown. All aspects shown on the letter-value boxplot are
actual observations, thus remaining faithful to the principles that
governed Tukey's original boxplot.
}
\section{Computed/reported variables}{

\describe{
  \item{k}{Number of Letter Values used for the display}
  \item{LV}{Name of the Letter Value}
  \item{width}{width of the interquartile box}
}
}

\examples{
library(ggplot2)
p <- ggplot(mpg, aes(class, hwy))
p + geom_lv(aes(fill = after_stat(LV))) + scale_fill_brewer()
p + geom_lv() + geom_jitter(width = 0.2)
p + geom_lv(aes(fill = after_stat(LV))) + scale_fill_lv()

# Outliers
p + geom_lv(varwidth = TRUE, aes(fill = after_stat(LV))) + scale_fill_lv()
p + geom_lv(fill = "grey80", colour = "black")
p + geom_lv(outlier.colour = "red", outlier.shape = 1)

# Plots are automatically dodged when any aesthetic is a factor
p + geom_lv(aes(fill = drv))

# varwidth adjusts the width of the boxes according to the number of observations
ggplot(ontime, aes(UniqueCarrier, TaxiIn + TaxiOut)) +
  geom_lv(aes(fill = after_stat(LV)), varwidth=TRUE) +
  scale_fill_lv() +
  scale_y_sqrt() +
  theme_bw()

ontime$DayOfWeek <- as.POSIXlt(ontime$FlightDate)$wday
ggplot(ontime, aes(factor(DayOfWeek), TaxiIn + TaxiOut)) +
  geom_lv(aes(fill = after_stat(LV))) +
  scale_fill_lv() +
  scale_y_sqrt() +
  theme_bw()
}
\references{
McGill, R., Tukey, J. W. and Larsen, W. A. (1978) Variations of
    box plots. The American Statistician 32, 12-16.
}
\seealso{
\code{\link[ggplot2]{stat_quantile}} to view quantiles conditioned on a
  continuous variable.
}
\keyword{datasets}
