% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{as_data_dict_mlstr}
\alias{as_data_dict_mlstr}
\title{Validate and coerce any object as an Opal data dictionary format}
\usage{
as_data_dict_mlstr(object, name_standard = FALSE)
}
\arguments{
\item{object}{A potential valid data dictionary to be coerced.}

\item{name_standard}{Whether the input data dictionary has variable names
compatible with Maelstrom Research ecosystem, including Opal)or not.
FALSE by default.}
}
\value{
A list of data frame(s) with \code{madshapR::class} 'data_dict_mlstr'.
}
\description{
Validates the input object as a valid data dictionary compliant with formats
used in Maelstrom Research ecosystem, including Opal, and returns it with
the appropriate \code{madshapR::class} attribute. This function mainly helps
validate input within other functions of the package but could be used to
check if an object is valid for use in a function.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

The object may be specifically formatted to be compatible with additional
\href{https://maelstrom-research.org/page/software}{Maelstrom Research software},
in particular \href{https://www.obiba.org/pages/products/opal/}{Opal environments}.
}
\examples{
{

library(dplyr)

###### Example 1 : use the function to apply the attribute "data_dict" to the 
# object. 
data_dict <- 
  as_data_dict_mlstr(madshapR_examples$`data_dictionary_example`)

glimpse(data_dict)

###### Example 2 : use the function to shape the data dictionary formatted as
# data_dict_mlstr to data_dict object. The function mainly converts valueType 
# column into corresponding typeof/class columns in 'Variables', and converts
# missing column into "na_values" column. 
data_dict <- 
  as_data_dict_mlstr(madshapR_examples$`data_dictionary_example - as_data_dict`)
  
glimpse(data_dict)

}

}
\seealso{
For a better assessment, please use \code{\link[=data_dict_evaluate]{data_dict_evaluate()}}.
}
