% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental.R
\name{is_category}
\alias{is_category}
\title{Test and validate if an object is a categorical variable.}
\usage{
is_category(x, threshold = NULL)
}
\arguments{
\item{x}{object to be coerced.}

\item{threshold}{Optional. The function returns TRUE if the number of unique
values in the input vector is lower.}
}
\value{
A logical.
}
\description{
Tests if the input object is a categorical variable. This function mainly helps
validate input within other functions of the package but could be used
to check if a column is categorical.
}
\examples{
{

library(dplyr)

###### Example 1: use madshapR_examples provided by the package
dataset <-
  madshapR_examples$`dataset_example` \%>\%
  mutate(prg_ever_cat = as_category(prg_ever)) \%>\%
  mutate(prg_ever_no_cat = drop_category(prg_ever))
  
is_category(dataset[['prg_ever_cat']])
is_category(dataset[['prg_ever_no_cat']])

###### Example 2: any data frame can be a dataset
iris \%>\% reframe(across(everything(), is_category))

}

}
