% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimReduce.R
\name{dimReduce}
\alias{dimReduce}
\title{dimReduce}
\usage{
dimReduce(x, dim_exclude = NULL)
}
\arguments{
\item{x}{MAgPIE object which should be reduced}

\item{dim_exclude}{Vector with names of dimensions which must not be reduced}
}
\value{
The reduced MAgPIE object
}
\description{
Remove dimensions which contain identical data for all elements in it
}
\note{
This function has some similarities to \code{\link{collapseDim}}, but
serves a different purpose. While \code{\link{collapseDim}} only removes
dimensions which contain only a single element or which it is
specifically told to remove, \code{\link{dimReduce}} looks whether the
entries of a multi-entry dimension are all the same and removes dimensions
for which this is the case. In some cases both will lead to the same result
but in many other cases the results will differ.
}
\examples{

# create data with 5 identical scenarios
p <- add_dimension(maxample("pop")[1:3, 1:3, ], nm = paste0("scen", 1:2))
str(p)
str(dimReduce(p))

# set years to same value
p[, , ] <- setYears(p[, 1, ], NULL)
str(p)
str(dimReduce(p))

# set regions to same value
p[, , ] <- setCells(p[1, , ], "GLO")
str(p)
str(dimReduce(p))
}
\seealso{
\code{\link{add_dimension}}
}
\author{
Jan Philipp Dietrich
}
