% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mallet.R
\name{mallet.read.dir}
\alias{mallet.read.dir}
\title{Import documents from a directory into Mallet format}
\usage{
mallet.read.dir(Dir)
}
\arguments{
\item{Dir}{The path to a directory containing one document per file.}
}
\value{
a \code{data.frame} with file \code{id} and \code{text} content.
}
\description{
This function takes a directory path as its only argument and returns a
 \code{data.frame} with two columns: <id> & <text>,
 which can be passed to the \code{mallet.import} function.
 This \code{data.frame} has as many rows as there are files in the \code{Dir}.
}
\note{
This function was contributed to RMallet by Dan Bowen.
}
\examples{
\dontrun{
directory <- system.file("stoplists", package = "mallet")
stoplists <- mallet.read.dir(directory)
}

}
\seealso{
\code{\link{mallet.import}}
}
\author{
Dan Bowen
}
