% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-gridmap.R
\name{esp_get_gridmap}
\alias{esp_get_gridmap}
\alias{esp_get_hex_prov}
\alias{esp_get_hex_ccaa}
\alias{esp_get_grid_prov}
\alias{esp_get_grid_ccaa}
\title{Get a \code{\link[sf:sf]{sf}} hexbin or squared \code{POLYGON} of Spain}
\usage{
esp_get_hex_prov(prov = NULL)

esp_get_hex_ccaa(ccaa = NULL)

esp_get_grid_prov(prov = NULL)

esp_get_grid_ccaa(ccaa = NULL)
}
\arguments{
\item{prov, ccaa}{character. A vector of names and/or codes for provinces
and autonomous communities or \code{NULL} to get all the data. See \strong{Details}.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
Loads a hexbin map (\code{\link[sf:sf]{sf}} object) or a map of squares with the
boundaries of the provinces or autonomous communities of Spain.
}
\details{
Hexbin (or grid) maps have an advantage over traditional choropleth maps.
In choropleths, regions with larger polygons tend to appear more prominent
simply because of their size, which introduces visual bias. With hexbin
maps, each region is represented equally, reducing this bias.

You can use and mix names, ISO codes, \code{"codauto"/ "cpro"} codes (see
\link{esp_codelist}) and NUTS codes of different levels.

When using a code corresponding to a higher level (e.g.
\code{esp_get_prov("Andalucia")}) all the corresponding units of that level are
provided (in this case, all the provinces of Andalusia).

Results are provided in \strong{EPSG:4258}, use \code{\link[sf:st_transform]{sf::st_transform()}}
to change the projection.
}
\examples{
\dontshow{if (esp_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
esp <- esp_get_spain()
hexccaa <- esp_get_hex_ccaa()

library(ggplot2)

ggplot(hexccaa) +
  geom_sf(data = esp) +
  geom_sf(aes(fill = codauto), alpha = 0.3, show.legend = FALSE) +
  geom_sf_text(aes(label = label), check_overlap = TRUE) +
  theme_void() +
  labs(title = "Hexbin: CCAA")


hexprov <- esp_get_hex_prov()

ggplot(hexprov) +
  geom_sf(data = esp) +
  geom_sf(aes(fill = codauto), alpha = 0.3, show.legend = FALSE) +
  geom_sf_text(aes(label = label), check_overlap = TRUE) +
  theme_void() +
  labs(title = "Hexbin: Provinces")


gridccaa <- esp_get_grid_ccaa()

ggplot(gridccaa) +
  geom_sf(data = esp) +
  geom_sf(aes(fill = codauto), alpha = 0.3, show.legend = FALSE) +
  geom_sf_text(aes(label = label), check_overlap = TRUE) +
  theme_void() +
  labs(title = "Grid: CCAA")


gridprov <- esp_get_grid_prov()

ggplot(gridprov) +
  geom_sf(data = esp) +
  geom_sf(aes(fill = codauto), alpha = 0.3, show.legend = FALSE) +
  geom_sf_text(aes(label = label), check_overlap = TRUE) +
  theme_void() +
  labs(title = "Grid: Provinces")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{esp_get_simpl}}.

Other datasets representing political borders:
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_ccaa_siane}()},
\code{\link{esp_get_comarca}()},
\code{\link{esp_get_countries_siane}()},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_munic_siane}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_prov_siane}()},
\code{\link{esp_get_simpl}},
\code{\link{esp_get_spain}()},
\code{\link{esp_get_spain_siane}()},
\code{\link{esp_siane_bulk_download}()}
}
\concept{political}
