% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OS.r
\name{olkin_siotani}
\alias{olkin_siotani}
\title{Olkin & Siotani variance-covariance matrix}
\usage{
olkin_siotani(data, n, type = c("average", "weighted", "simple"))
}
\arguments{
\item{data}{A correlation matrix or a list of correlation matrices.}

\item{n}{Sample size}

\item{type}{The type of Olkin and Siotani correction to make.}
}
\value{
List of matrices, same length as the number of studies or number of correlation matrices.
}
\description{
Computational function to compute the Olkin & Siotani (1976)
variance-covariance matrix for correlation matrices. It allows the user to
specify three different computations.
}
\details{
The three possible computations that can be specified are:
\itemize{
\item average: Average all the correlations element-wise to pool into a single correlation matrix.
The variance-covariance is computed from the averaged correlation matrix, then divided by study specific sample sizes.
\item weighted: Same as the average process-wise, but uses a weighted average to pool into a single correlation matrix.
\item simple: Computes the variance-covariance for each individual correlation matrix, then divide these by the study specific sample sizes.
}
}
\references{
Becker, B. J. (1992). Using results from replicated studies to estimate linear models. Journal of Educational Statistics, 17(4), 341-362.
Olkin, I. (1976). Asymptotic distribution of functions of a correlation matrix. Essays in provability and statistics: A volume in honor of Professor Junjiro Ogawa.
}
