% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{rollup_mass_props_fast}
\alias{rollup_mass_props_fast}
\title{Roll up mass properties without input validation}
\usage{
rollup_mass_props_fast(tree, df)
}
\arguments{
\item{tree}{An 'igraph' tree whose vertices are named as the values of the \code{id}
column of \code{df} and whose directed edges point from child id to parent id.}

\item{df}{A data frame  with (at least) these columns: \code{id}, \code{mass}, \code{Cx},
\code{Cy}, \code{Cz}, \code{Ixx}, \code{Iyy}, \code{Izz}, \code{Ixy}, \code{Ixz}, \code{Iyz}, \code{POIconv}, \code{Ipoint}.}
}
\value{
The updated data frame
}
\description{
\code{rollup_mass_props_fast()} performs the same operation as \code{rollup_mass_props()}
but omits input validation. It is somewhat faster than  \code{rollup_mass_props()} but should
be used with caution and only under circumstances in which the caller assumes
responsibility for validity of input. Its behavior when passed ill-formed input is unspecified.
}
\examples{
rollup_mass_props_fast(test_tree, test_table)

}
