% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airDensity.R
\name{airDensity}
\alias{airDensity}
\title{Models for calculating air density based on environmental conditions}
\usage{
airDensity(Temp = 20, p = 1013.25, h = 50, unitsENV = c("deg.C", "hPa",
  "\%"), x_CO2 = 4e-04, model = "CIMP2007")
}
\arguments{
\item{Temp}{ambient temperature in weighing room.}

\item{p}{barometric pressure in weighing room.}

\item{h}{relative humidity in weighing room.}

\item{unitsENV}{character vector of length three with the units of
\code{p}, \code{Temp} and \code{h}.
Default is \code{c('deg.C', 'hPa', '\%')}. See \strong{unitsENV} below for more options.}

\item{x_CO2}{molar fraction of carbon dioxide in the air inside weighing room.}

\item{model}{model to use for air density calculation.
Must be one of \code{'CIMP2007'} (default),
\code{'CIMP.approx'} or \code{'Jones1978'}. See See Details for references.}
}
\value{
Numeric value of air density in \eqn{g~cm^{-3}}, according to chosen model.
}
\description{
The function uses environmental conditions information
(barometric pressure, temperature and
relative humidity.) to calculate a local air density value.
If no parameter is defined, the air
density at 20\eqn{^o}C, 1013.25 hPa and 50\% relative humidity is returned.
The air density value value can later be used to calculate the
Magnitude of Air Buoyancy Correction (\code{\link[=MABC]{MABC()}}).
The uncertainty of the air density value can be calculated using
the function \code{\link[=uncertAirDensity]{uncertAirDensity()}}.
}
\details{
Local air density can be estimated using one of several methods.
The most complete approach is the
CIMP complete formula (the default, \code{method = 'CIMP2007'})
as described in Picard et al (2008).
The CIMP approximated exponential formula (\code{method = 'CIMP.approx'})
and the method reported by Jones, (\code{method = 'Jones1978'}) (Harris, 2019)
are also included.
}
\section{unitsENV}{

Temperature units (\code{Temp}) can be either \code{'deg.C'}
(for Celsius degrees) or \code{'K'}.
Pressure units (\code{p}) can be any of \code{'mmHg'},
\code{'Pa'}, \code{'hPa'} or \code{'kPa'}.
Relative humidity (\code{h}) can be expressed as
fraction (\code{'frac'}) or as percentage (\code{'\%'}).
A typical arrangement for the parameter \code{unitsENV}
would be \code{c('deg.C', 'hPa', '\%')}.
}

\examples{
airDensity(Temp = 23.4, p = 612.3, h = 23,
           unitsENV = c('deg.C', 'mmHg', '\%')) # [g/cm^3]
airDensity(Temp = 23.4, p = 612.3, h = 23,
           unitsENV = c('deg.C', 'mmHg', '\%'), model = 'CIMP.approx') # [g/cm^3]
airDensity(Temp = 23.4, p = 612.3, h = 23,
           unitsENV = c('deg.C', 'mmHg', '\%'), model = 'Jones1978')   # [g/cm^3]
}
\references{
Picard, A; Davis, R S; Gläser, M; Fujii, K  (2008). Revised formula for
the density of moist air (CIPM-2007).
Metrologia, 45(2), 149–155. doi:10.1088/0026-1394/45/2/004

Harris, G. (2019). Selected Laboratory and Measurement Practices and Procedures to Support Basic
Mass Calibrations. SOP 2 - Recommended Standard Operating Procedure for Applying Air Buoyancy
Corrections. National Institute of Standards and Technology (NIST). doi:10.6028/NIST.IR.6969-2019

Preguntar a andres referencia de la f'ormula simplificada exponencial
}
\seealso{
\code{\link[=MABC]{MABC()}} to calculate the Magnitude of Air Buoyancy Correction and
\code{\link[=uncertAirDensity]{uncertAirDensity()}} to estimate the uncertainty of the calculated air density.
}
