% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append.R
\name{append_column}
\alias{append_column}
\title{Append a Column to a Data Frame}
\usage{
append_column(.data, new_col, .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A data frame to which the column will be added.}

\item{new_col}{A vector containing the values of the new column to append.
The name of this vector will be used as the column name in the data frame.}

\item{.before}{(Optional) A string specifying the name of the column before which
the new column should be inserted. Defaults to `NULL`.}

\item{.after}{(Optional) A string specifying the name of the column after which
the new column should be inserted. Defaults to `NULL`.}
}
\value{
A data frame with the new column added at the specified position or at
the end if no position is specified.
}
\description{
Internal function to add a new column to a data frame and optionally position it
before or after a specified column.
}
\details{
If both `.before` and `.after` are provided, `.before` takes precedence. If neither
is provided, the new column is appended at the end of the data frame.

The column name is derived from the name of the input vector `new_col`.
}
\keyword{internal}
