% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_growth_male.R
\name{plot_growth_male}
\alias{plot_growth_male}
\title{Height (current + predicted) vs growth curves plot for males.}
\usage{
plot_growth_male(data, athlete)
}
\arguments{
\item{data}{A data frame. The object containing the raw data we wish to analize.}

\item{athlete}{A character string with the name of the athlete we wish to plot.}
}
\value{
A plot \code{(ggplot)}
}
\description{
This function returns a ggplot object showing the \strong{current} and \strong{predicted height} vs normal growth charts for american population.
}
\details{
Data for growth charts was obtained from the National Center for Health Statistics.

Please visit \url{https://www.cdc.gov/growthcharts/percentile_data_files.htm} to learn more about this information.

Be aware, players from different populations to the one used on these growth charts may not be well represented.

For females, use documentation for \strong{\code{plot_growth_female()}}
}
\examples{
plot_growth_male(data_sample, "Athlete 08")

}
