% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mazealls.r
\docType{package}
\name{mazealls}
\alias{mazealls-package}
\alias{mazealls}
\title{generate recursive mazes}
\description{
Generate recursive mazes.
}
\details{
Recursive generation of mazes proceeds roughly as follows: subdivide
the domain logicall into two or more parts, creating mazes in the 
sub-parts, then drawing dividing lines between them with some holes.
The holes in the dividing lines should be constructed so that the
sub-parts form a tree, with exactly one way to get from one of the
sub-parts to any one of the others. Then an optional outer boundary
with optional holes is drawn to finish the maze.
}
\note{
This package is dedicated to my friend, Abie Flaxman, who gave me the idea,
and other ideas.

If you like this package, please endorse the author for \sQuote{mazes} on
LinkedIn.
}
\section{unit length}{


The \code{unit_len} parameter controls the graphical length of one \sQuote{unit}, 
which is the length of holes between sections of the mazes, and is roughly the width
of the \sQuote{hallways} of a maze. Here is an example of using different
unit lengths in a stack of trapezoids

\if{html}{
\figure{unit-len-stack-trap-1.png}{options: style="width: 100\%;" alt="Figure: Stacked trapezoids"}
}
\if{latex}{
\figure{unit-len-stack-trap-1.png}{options: width=7cm}
}
}

\section{boundaries}{


The parameters \code{draw_boundary}, \code{boundary_lines}, \code{boundary_holes}, 
\code{num_boundary_holes} and \code{boundary_hole_color} control
the drawing of the final outer boundary of polynomial mazes. Without a boundary
the maze can be used in recursive construction. Adding a boundary provides the
typical entry and exit points of a maze. The parameter \code{draw_boundary} is a
single Boolean that controls whether the boundary is drawn or not.
The parameter \code{boundary_lines} may be a scalar Boolean, or a numeric
array giving the indices of which sides should have drawn boundary lines.
The sides are numbered in the order in which they appear, and are
controlled by the \code{clockwise} parameter. The parameter \code{boundary_holes}
is a numeric array giving the indices of the boundary lines that should
have holes. If \code{NULL}, then we uniformly choose \code{num_boundary_holes} holes 
at random. Holes can be drawn as colored segments with the
\code{boundary_hole_color}, which is a character array giving the color of each
hole. The value 'clear' stands in for clear holes.
Arrows can optionally be drawn at the boundary holes via the
\code{boundary_hole_arrows} parameter, which is either a logical array or a 
numerical array indicating which sides should have boundary hole arrows.

\if{html}{
\figure{boundary-stuff-1.png}{options: style="width: 100\%;" alt="Figure: Boundary Examples"}
}
\if{latex}{
\figure{boundary-stuff-1.png}{options: width=7cm}
}
}

\section{end side}{


The \code{end_side} parameter controls which side of the maze the turtle ends on.
The default value of 1 essentially causes the turtle to end where it 
started. The sides are numbered in the order in which the boundary would be
drawn. Along with the boundary controls, the ending side can be useful to join together 
polygons into more complex mazes.
}

\section{Legal Mumbo Jumbo}{


mazealls is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/shabbychef/mazealls}
  \item Report bugs at \url{https://github.com/shabbychef/mazealls/issues}
}

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}

\strong{Maintainer}: Steven E. Pav \email{shabbychef@gmail.com} (\href{https://orcid.org/0000-0002-4197-6195}{ORCID})

}
\keyword{package}
