% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genRandomSpanningTrees.R
\name{genRandomSpanningTrees}
\alias{genRandomSpanningTrees}
\title{Generate a set of random spanning trees.}
\usage{
genRandomSpanningTrees(m, n, type = "pruefer", simplify = TRUE)
}
\arguments{
\item{m}{[\code{integer(1)}]\cr
Number of random spanning trees to be generated.}

\item{n}{[\code{integer}]\cr
Number of nodes of the problem.}

\item{type}{[\code{character(1)}]\cr
String representing the desired format of the generated
spanning tree. Possible values are \dQuote{pruefer} (Pruefer-code),
\dQuote{edgelist} and \dQuote{charvec} (characteristic vector).
Default is \dQuote{pruefer}.}

\item{simplify}{[\code{logical(1)}]\cr
Should the result be simplified to a matrix if appropriate?
Only relevant if \code{type} is either \dQuote{pruefer} or
\dQuote{charvec}.
Default is \code{TRUE}.}
}
\value{
[\code{list} | \code{matrix}] Result type depends on \code{simplify}
  and \code{type}.
}
\description{
Generate a set of random spanning trees of a graph
given the number of nodes of the problem instance.
}
\examples{
genRandomSpanningTrees(3, 10)
genRandomSpanningTrees(3, 10, simplify = FALSE)

genRandomSpanningTrees(3, 10, type = "edgelist")
}
