% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa_operators.R
\name{mutUniformPruefer}
\alias{mutUniformPruefer}
\title{Uniform mutation for Pruefer code representation.}
\usage{
mutUniformPruefer(ind, p = 1/length(ind))
}
\arguments{
\item{ind}{[\code{integer}]\cr
Pruefer code.}

\item{p}{[\code{numeric(1)}]\cr
Probability of mutation of each component of \code{ind}.
Default is \code{1 / length(ind)}.}
}
\value{
[\code{integer}] Mutated Pruefer code.
}
\description{
\code{mutUniformPruefer} replaces each component of a Pruefer code of length n - 2
with probability \code{p} with a random node number between 1 and n.
}
\seealso{
Evolutionary multi-objective algorithm \code{\link{mcMSTEmoaZhou}}

Other mcMST EMOA mutators: 
\code{\link{mutEdgeExchange}()},
\code{\link{mutKEdgeExchange}()},
\code{\link{mutSubforestMST}()},
\code{\link{mutSubgraphMST}()}
}
\concept{mcMST EMOA mutators}
