% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEdges.R
\name{plotEdges}
\alias{plotEdges}
\title{Visualize edges common to several solutions.}
\usage{
plotEdges(x, n = NULL, normalize = TRUE, ...)
}
\arguments{
\item{x}{[\code{list}]\cr
List of characteristic vectors.}

\item{n}{[\code{integer(1)}]\cr
Number of nodes of the problem instance.
Default is \code{sqrt(length(cv))} where cv is the first component of
\code{x}.}

\item{normalize}{[\code{logical(1)}]\cr
Shall edge frequencies be plotted? Default is code TRUE.}

\item{...}{[any]\cr
Further arguments passed down to \code{\link[qgraph]{qgraph}}.}
}
\value{
Nothing
}
\description{
Given a list of characteristic vectors (graphs) the function plots
an embedding of the nodes in the Euclidean plane and depicts an edge if and
only if it is contained in at least one of the graphs. The edge thickness
indicates the number of graphs the edge is part of.
}
\seealso{
Other result visualization: 
\code{\link{plotEdgeFrequency}()}
}
\concept{result visualization}
