% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc.R
\name{read_assoc}
\alias{read_assoc}
\title{Read association scores from file}
\usage{
read_assoc(file, sep = "\\t", file_encoding = "UTF-8", ...)
}
\arguments{
\item{file}{Path of the input file.}

\item{sep}{Field separator in the input file.}

\item{file_encoding}{Encoding of the input file.}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{\link{assoc_scores}}.
}
\description{
This function reads a file written by \code{\link[=write_assoc]{write_assoc()}}.
}
\examples{
txt1 <- "we're just two lost souls swimming in a fish bowl,
year after year, running over the same old ground,
what have we found? the same old fears.
wish you were here."
flist1 <- freqlist(txt1, as_text = TRUE)
txt2 <- "picture yourself in a boat on a river
with tangerine dreams and marmelade skies
somebody calls you, you answer quite slowly
a girl with kaleidoscope eyes"
flist2 <- freqlist(txt2, as_text = TRUE)
(scores <- assoc_scores(flist1, flist2, min_freq = 0))
\dontshow{.old_wd <- setwd(tempdir())}
write_assoc(scores, "example_scores.tab")
(scores2 <- read_assoc("example_scores.tab"))
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=write_assoc]{write_assoc()}}

Other reading functions: 
\code{\link{read_conc}()},
\code{\link{read_fnames}()},
\code{\link{read_freqlist}()},
\code{\link{read_tokens}()},
\code{\link{read_txt}()},
\code{\link{read_types}()}
}
\concept{reading functions}
