% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/assoc.R, R/freqlist.R
\name{type_names}
\alias{type_names}
\alias{type_names.assoc_scores}
\alias{type_names.freqlist}
\title{Return the names of the types in an object}
\usage{
type_names(x, ...)

\method{type_names}{assoc_scores}(x, ...)

\method{type_names}{freqlist}(x, ...)
}
\arguments{
\item{x}{An object of any of the classes for which the method is implemented.}

\item{...}{Additional arguments.}
}
\value{
Character vector.
}
\description{
This method returns the names of the types represented in an object.
}
\examples{
# for a freqlist object
(flist <- freqlist("The man and the mouse.", as_text = TRUE))

type_names(flist)

# for an assoc_scores object
a <- c(10,    30,    15,    1)
b <- c(200, 1000,  5000,  300)
c <- c(100,   14,    16,    4)
d <- c(300, 5000, 10000, 6000)
types <- c("four", "fictitious", "toy", "examples")

(scores <- assoc_abcd(a, b, c, d, types = types))
type_names(scores)
}
\seealso{
Other getters and setters: 
\code{\link{n_tokens}()},
\code{\link{n_types}()},
\code{\link{orig_ranks}()},
\code{\link{ranks}()},
\code{\link{tot_n_tokens}()}
}
\concept{getters and setters}
