#' Example Data
#'
#' A data set from White et al. (2008), which is also described in Mun et al. (2015, 2022)
#'
#' @docType data
#'
#' @usage data(dat.pfi)
#'
#' @format The data fram contains 194 rows and 5 columns:
#' \describe{
#' \item{m0}{the number of standard alcohol drinks consumed at baseline}
#' \item{int_PF}{1: received personalized feedback interventions (PFI); 0: did not receive PFI}
#' \item{year_new}{1: first-year college student; 0: otherwise}
#' \item{race_new}{1: white; 0: non-white}
#' \item{y}{the number of standard alcohol drinks consumed at post-intervention; the response variable}
#' }
#'
#' @references
#' Mun, E.-Y., Zhou, Z., Huh, D., Tan, L., Li, D., Tanner-Smith, E. E., Walters, S. T., & Larimer, M.E. (2022). Brief alcohol interventions are effective through six months: Findings from marginalized zero-inflated Poisson and negative binomial models in a two-step IPD meta-analysis. Prevention Science. (under review)\cr \cr
#' Mun, E. Y., De La Torre, J., Atkins, D. C., White, H. R., Ray, A. E., Kim, S. Y., ... & The Project INTEGRATE Team. (2015). Project INTEGRATE: An integrative study of brief alcohol interventions for college students. Psychology of Addictive Behaviors, 29(1), 34-48.\cr \cr
#' White, H. R., Mun, E.-Y., & Morgan, T. J. (2008). Do brief personalized feedback interventions work for mandated students or is it just getting caught that works? Psychology of Addictive Behaviors, 22 (1), 107–116. https://doi.org/10.1037/0893-164X.22.1.107.
#'
"dat.pfi"
