% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_mc.R
\name{expect_mc_iid_mean}
\alias{expect_mc_iid_mean}
\title{Test iid samples for correct mean}
\usage{
expect_mc_iid_mean(object, mean, control = NULL)
}
\arguments{
\item{object}{A function taking one argument - that generates n univariate iid samples.}

\item{mean}{The expected mean of the samples returned from object.}

\item{control}{a list controlling the algorithm
\itemize{
\item n number of samples to be taken in the first step. Default: 1e3
\item maxseqsteps: Number of sequential attempts to use. Default: 7.
\item incn: Factor by which to multiply n from the second  sequential attempt onward. Default: 4.
\item level: bound on the type I error, ie the probability of wrongly rejecting a sampler with the correct distribution. Default: 1e-5.
\item debug: If positive  then debug information will be printed via 'message()'. Default: 0.
}}
}
\value{
The first argument, invisibly, to allow chaining of expectations.
}
\description{
Test if samples are coming from a specific mean. Not guaranteed to
be exact, as it estimates the standard error from the sample.
}
\examples{
   sampler <- function(n) rbinom(n,prob=0.6,size=5)
   expect_mc_iid_mean(sampler, mean=3)
   testthat::expect_error(expect_mc_iid_mean(sampler, mean=2))

}
