% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdir.onesided.R
\name{mdir.onesided}
\alias{mdir.onesided}
\title{Two-sample multiple-direction log rank test for stochastic ordered alternatives}
\usage{
mdir.onesided(data, group1, rg = list(c(0, 0), c(0, 4), c(4, 0)),
  w.user = NA, wild = "rade", iter = 10000, dig_p = 3,
  dig_stat = 3)
}
\arguments{
\item{data}{A data.frame, list or environment containing the variables \code{time},
\code{event} (with values 0 for censored and 1 for uncensored) and \code{group}.}

\item{group1}{The name or the coding for the first group in the data set (neceassary for
a one-sided testing problem).}

\item{rg}{A list containing the exponents \code{c(r, g)} of the directions
 \eqn{w(x) = x^r (1-x)^g} or \code{NA}. Both exponents r,g need to be natural numbers including 0.
Default is \code{list(c(0, 0), c(0, 4), c(4, 0))} corresponding to the choice of the
proportional, early and late direction/weight.}

\item{w.user}{A list containing the user specified functions or \code{NA} (default).}

\item{wild}{The wild bootstrap approach used for estimating the p-value. The Rademacher
(\code{rade}, default), the normal distribution (\code{norm}) or the centred
Poisson distribution (\code{pois}) approach can be selected.}

\item{iter}{The number of iteration used for calculating the wild bootstrap p-value.
The default option is 10000.}

\item{dig_p}{The p-values are rounded to \code{dig_p} digits, the default is 3.}

\item{dig_stat}{The test statistic is rounded to \code{dig_stat} digits, the default is 3.}
}
\value{
An  \code{mdirone} object containing the following components:
\item{Descriptive}{The directions used and whether the directions specified by the user were
   linearly independent.}
 \item{p.value}{The p-value of the one-sided multiple-direction logrank test using the
   the using the permutation approach (Perm.).}
 \item{wild}{The wild bootstrap approach which was used}
 \item{stat}{Value of the one-sided multiple-direction logrank statistic.}
 \item{rg}{The argument \code{rg}.}
 \item{w.user}{The argument \code{w.user}.}
 \item{group1}{The name of the first group.}
 \item{indep}{logical or NA. \code{indep}\eqn{=}\code{TRUE}/\code{FALSE} when the directions specified by \code{rg} were linearly independent.
      \code{indep}\eqn{=}\code{NA} when \code{rg}\eqn{=}\code{NA}.}
 \item{iter}{The number of iterations used for calculating the wild bootstrap p-value.}
}
\description{
The mdir.onesided function calculates the multiple-direction logrank
statistic for (one-sided) stochastic ordered alternatives and
its p-value  based on a wild bootstrap approach
}
\details{
The function provides the multiple-direction logrank statistic for
  the two sample one-sided testing problem of stochastic ordering within right-censored survival data.
  The null hypothesis \eqn{H:F_1=F_2} is tested against the one-sided alternative \eqn{K:F_1 \ge F_2,
  F_1 \neq F_2}. The first group corresponding to \eqn{F_1} can be specified
  by the argument \code{group1}. An arbitrary amount of directions/weights of the form
  \eqn{w(x) = x^r (1-x)^g} for natural numbers r,g (including 0) can be chosen in the list
  \code{rg}. The multiple-direction onesided logrank test needs linearly independent directions.
  A check for this is implemented. If the directions chosen by the user are
  linearly dependent then a subset consisting of linearly independent directions
  is selected automatically. The user can also specify weights of a different shape in the list
  \code{w.user}. But if the user specified own weights in \code{w.user} then there is no
  automatic check for linear independence.

  The \code{mdir.onesided} function returns the test statistic and the p-value
  based on a wild bootstrap procedure \code{wild}.
}
\examples{
library(coin)
data(GTSG)
out <- mdir.onesided(data = GTSG, group1 = "Chemotherapy+Radiation", iter = 1000)

## Detailed information:
summary(out)

}
\references{
Ditzhaus, M., Pauly, M. (2018). Wild bootstrap logrank tests with
broader power functions for testing superiority. arXiv preprint arXiv:arXiv:1808.05627.
}
\seealso{
\code{\link[mdir.logrank]{mdir.onesided}}
}
