% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-bayes-factor.R
\name{log_mll}
\alias{log_mll}
\title{Log marginal likelihood calculation}
\usage{
log_mll(x, ..., force = FALSE)
}
\arguments{
\item{x}{A \link[=dcm_estimate]{measrdcm} object estimated with
\code{backend = "optim"}.}

\item{...}{Unused.}

\item{force}{If the criterion has already been added to the
model object with \code{\link[=add_criterion]{add_criterion()}}, should it be recalculated. Default is
\code{FALSE}.}
}
\value{
The estimate of the log marginal likelihood.
}
\description{
Calculate the log marginal likelihood with bridge sampling (Meng & Wong,
1996). This is a wrapper around \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.
Therefore, log marginal likelihood calculation is currently only available
for models estimated with \code{{rstan}} using MCMC.
}
\examples{
\dontshow{if (measr_examples()) withAutoprint(\{ # examplesIf}
model_spec <- dcm_specify(
  qmatrix = dcmdata::mdm_qmatrix,
  identifier = "item"
)
model <- dcm_estimate(
  dcm_spec = model_spec,
  data = dcmdata::mdm_data,
  identifier = "respondent",
  method = "variational",
  seed = 63277
)

log_mll(model)
\dontshow{\}) # examplesIf}
}
\references{
Meng, X.-L., & Wong, W. H. (1996). Simulating ratios of
normalizing constants via a simple identity: A theoretical exploration.
\emph{Statistical Sinica, 6}(4), 831-860.
\url{https://www.jstor.org/stable/24306045}
}
