% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-class-dcm-estimate.R
\name{measrdcm}
\alias{measrdcm}
\title{S7 class for measrdcm objects}
\usage{
measrdcm(
  model_spec = NULL,
  data = list(),
  stancode = character(0),
  method = stanmethod(),
  algorithm = character(0),
  backend = stanbackend(),
  model = list(),
  respondent_estimates = list(),
  fit = list(),
  criteria = list(),
  reliability = list(),
  file = character(0),
  version = list()
)
}
\arguments{
\item{model_spec}{The model specification used to estimate the model.}

\item{data}{The data used to estimate the model.}

\item{stancode}{The model code in \emph{Stan} language.}

\item{method}{The method used to fit the model.}

\item{algorithm}{The name of the algorithm used to fit the model.}

\item{backend}{The name of the backend used to fit the model.}

\item{model}{The fitted Stan model. This will object of class
\link[rstan:stanfit-class]{rstan::stanfit} if \code{backend = "rstan"} and
\code{\link[cmdstanr:CmdStanMCMC]{CmdStanMCMC}} if \code{backend = "cmdstanr"} was
specified when fitting the model.}

\item{respondent_estimates}{An empty list for adding estimated person
parameters after fitting the model.}

\item{fit}{An empty list for adding model fit information after fitting the
model.}

\item{criteria}{An empty list for adding information criteria after fitting
the model.}

\item{reliability}{An empty list for adding reliability information after
fitting the model.}

\item{file}{Optional name of a file which the model objects was saved to
or loaded from.}

\item{version}{The versions of measr, \emph{Stan}, and rstan or cmdstanr that were
used to fit the model.}
}
\value{
A \code{measrdcm} object.
}
\description{
The \code{measrdcm} constructor is exported to facilitate the conversion of other
model objects (e.g., \code{stanfit}) to \code{measrdcm} objects. We do not expect or
recommend calling this function directly, unless you are creating a method
for converting to \code{measrdcm}. Rather, to create a \code{measrdcm} object, one
should use \code{\link[=dcm_estimate]{dcm_estimate()}}.
}
\examples{
qmatrix <- tibble::tibble(
  att1 = sample(0:1, size = 15, replace = TRUE),
  att2 = sample(0:1, size = 15, replace = TRUE),
  att3 = sample(0:1, size = 15, replace = TRUE),
  att4 = sample(0:1, size = 15, replace = TRUE)
)

spec <- dcm_specify(qmatrix = qmatrix)

measrdcm(spec)
}
\seealso{
\code{\link[=dcm_estimate]{dcm_estimate()}}.
}
\concept{Stan}
