% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{haemoglobin}
\alias{haemoglobin}
\title{Low-dose iron supplements haemoglobin data [internal outcome-validation study]}
\format{
A data frame with 400 rows and 3 variables:
\describe{
  \item{capillary}{Haemoglobin levels measured in capillary blood (g/L)}
  \item{supplement}{Low-dose iron supplement (20 mg/d) (0 = no, 1 = yes)}
  \item{venous}{Haemoglobin levels measured in venous blood (g/L)}
}
}
\usage{
haemoglobin
}
\description{
Capillary haemoglobin and venous haemoglobin levels of 400 subjects of a trial investigating the efficacy of low-dose iron supplements during pregnancy.
Venous haemoglobin levels were observed of approximately 25\% of the subjects included in the trial.
}
\details{
This is a simulated data set inspired by a trial investigating low-dose iron supplements <doi:10.1093/ajcn/78.1.145>. A motivating example using the example data can be found here: <doi:10.1002/sim.8359>
}
\examples{
data("haemoglobin", package = "mecor")
}
\references{
Maria Makrides, Caroline A Crowther, Robert A Gibson, Rosalind S Gibson, and C Murray Skeaff. Efficacy and tolerability of low-dose iron supplements during pregnancy: a randomized controlled trial. The American Journal of Clinical Nutrition (2003). <doi:10.1093/ajcn/78.1.145>

Linda Nab, Rolf HH Groenwold, Paco MJ Welsing, and Maarten van Smeden. Measurement error in continuous endpoints in randomised trials: Problems and solutions. Statistics in Medicine (2019). <doi:10.1002/sim.8359>
}
\keyword{datasets}
