% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vat}
\alias{vat}
\title{NEO visceral adipose tissue data [internal covariate-validation study]}
\format{
A data frame with 650 rows and 6 variables:
\describe{
  \item{ir_ln}{Natural logarithm of insulin resistance (fasting glucose (mmol/L) x fasting insulin (mU/L) / 22.5)}
  \item{wc}{Waist circumference (standardised, cm)}
  \item{sex}{Sex (0 = male, 1 = female)}
  \item{age}{Age (years)}
  \item{tbf}{Total body fat (standardised, \%)}
  \item{vat}{Visceral adipose tissue (standardised, cm^2)}
}
}
\usage{
vat
}
\description{
Insulin resistance, waist circumference, sex, age, total body fat and visceral adipose tissue of 650 individuals from the
Netherlands Epidemiology of Obesity (NEO) study. Visceral adipose tissue measurements were taken of approximately 40\% of the individuals, at random.
}
\details{
This is a simulated data set inspired by the NEO data <doi:10.1007/s10654-013-9801-3>. A motivating example using the example data can be found here: <doi:10.1093/aje/kwab114>
}
\examples{
data("vat", package = "mecor")
}
\references{
Renee de Mutsert, Martin den Heijer, Ton J Rabelink, Johannes WA Smit, Johannes A Romijn, Johan W Jukema, Albert de Roos, Christa M Cobbaert, Margreet Kloppenburg, Saskia le Cessie, Saskia Middeldorp, Frits R Rosendaal. The Netherlands epidemiology of obesity (NEO) study: Study design and data collection. European Journal of Epidemiology (2013). <doi:10.1007/s10654-013-9801-3>

Linda Nab, Maarten van Smeden, Renee de Mutsert, Frits R Rosendaal, and Rolf HH Groenwold. Sampling strategies for internal validation samples for exposure measurement error correction: A study of visceral adipose tissue measures replaced by waist circumference measures. American Journal of Epidemiology (2021). <doi:10.1093/aje/kwab114>
}
\keyword{datasets}
