% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials.R
\name{meetupr_credentials}
\alias{meetupr_credentials}
\alias{meetupr_key_set}
\alias{meetupr_key_get}
\alias{meetupr_key_delete}
\title{Manage API Keys via Environment Variables}
\usage{
meetupr_key_set(key, value, client_name = get_client_name())

meetupr_key_get(key, client_name = get_client_name(), error = TRUE)

meetupr_key_delete(key, client_name = get_client_name())
}
\arguments{
\item{key}{Key name: \code{"client_key"}, \code{"client_secret"}, \code{"encrypt_path"},
\code{"encrypt_pwd"}, \code{"jwt_token"} or \code{"jwt_issuer"}.}

\item{value}{Value to be stored.}

\item{client_name}{A string representing the name of the client. By
default, it is set to \code{"meetupr"} and retrieved from the
\code{MEETUPR_CLIENT_NAME} environment variable.}

\item{error}{Throw error if key not found. Default TRUE.}
}
\value{
\code{meetupr_key_set()} and \code{meetupr_key_delete()} return
NULL (invisibly), and \code{meetupr_key_get()} returns a
character string or NA.
}
\description{
Store and retrieve credentials using environment variables.
}
\details{
This is an alias of \code{meetupr_credentials} with hyphenated envvar names.
Credentials are stored as environment variables with the pattern
\code{{client_name}-{key}} (e.g., \code{meetupr-client_key}).
\itemize{
\item \code{client_key}: OAuth client ID
\item \code{client_secret}: OAuth client secret
\item \code{encrypt_path}: Path to encrypted token file
\item \code{encrypt_pwd}: Password for encrypted token
\item \code{jwt_token}: JWT token for service account authentication
\item \code{jwt_issuer}: JWT issuer, Meetup account number
}
}
\section{Functions}{
\itemize{
\item \code{meetupr_key_set()}: Store a key in environment variables

\item \code{meetupr_key_get()}: Retrieve a key from environment variables

\item \code{meetupr_key_delete()}: Delete a key from environment variables

}}
