% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_and_merge.R
\name{simulate_and_merge}
\alias{simulate_and_merge}
\title{Simulate the MVG and merge the HEMs}
\usage{
simulate_and_merge(
  mvg_params = NULL,
  n_runs = NULL,
  n_sims = NULL,
  cor_matrix = NULL
)
}
\arguments{
\item{mvg_params}{parameters from the multivariate Gaussian distribution}

\item{n_runs}{Number of rows for the output merged data}

\item{n_sims}{Number of simulations for the multivariate Gaussian distribution to find the optimal merge}

\item{cor_matrix}{Correlation matrix}
}
\value{
Returns a merged dataframe as stated in the description
}
\description{
\code{simulate_and_merge} takes as input the parameters of the multivariate Gaussian distribution and simulates multiple samples.
The number of samples is determined by \code{n_sims}.
On each simulation, each HEM of the experimental data is sorted from lowest to highest independently.
Then, the simulated MGD is used as the model to arrange the experimental data.
For instance, if on the MGD the 10th highest value of HEM 1 is paired with the 2nd highest and the 4th highest values of HEMs 2 and 3 respectively,
Then, we modify the experimental data to copy this arrangement.
After merging and arranging, the 10th highest value of HEM 1 on the experimental data will be paired with the 2nd highest and the 4th highest values of HEMs 2 and 3 respectively.
The algorithm does multiple simulations of the MGD and keeps the sample that gives the lowest error on the correlation matrix when the data is merged w.r.t. the correlation matrix of the experimental data.
}
\examples{
n_pmcs <- 6
data_much <- mergingTools::process_raw_experiments(data = data_much_raw_vignette,
                                                   n_pmcs = n_pmcs)
cor_matrix <- mergingTools::correlation_matrix(splitted_data = data_much)
dep_lvl <- 0.85
# Remove the HEMs which are linearly dependant on other HEMs
cor_matrix_independent <- mergingTools::get_independent_matrix(cor_matrix = cor_matrix,
                                                               dep_lvl = dep_lvl)
mvg_params <- mergingTools::generate_mvg_params(splitted_data = data_much,
                                                cor_matrix = cor_matrix_independent)
n_sims <- 10
n_runs <- 1000
merged_data <- mergingTools::simulate_and_merge(mvg_params = mvg_params,
                                                n_runs = n_runs,
                                                n_sims = n_sims,
                                                cor_matrix = cor_matrix_independent)
}
\keyword{MUCH}
