% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMD.R
\name{SMD_from_mean}
\alias{SMD_from_mean}
\title{Standardized Mean Difference (SMD) from Means and Pooled Standard Deviation}
\usage{
SMD_from_mean(M1, M2, SD_pooled)
}
\arguments{
\item{M1}{treatment effect size group 1}

\item{M2}{treatment effect size group 2}

\item{SD_pooled}{the pooled standard deviation or the standard deviation of the control group in case Glass's delta should be calculated}
}
\value{
Standardized Mean Differences
}
\description{
Calculates the SMD. It needs to be provided with the pooled standard deviation. If the pooled standard deviation is not available \code{\link[=SMD_from_group]{SMD_from_group()}} provides a direct method to calculate the SMD and also offers different forms like Hedges' g or Cohen's d.
}
\details{
CAVE: If you want to get Hedges' g it is insufficient to simply pool the standard deviation with \code{\link[=SDp_from_SD]{SDp_from_SD()}}. The resulting SMD needs to be further multiplied with the hedges factor. This is done automatically when you use \code{\link[=SMD_from_group]{SMD_from_group()}}.
}
\examples{
# Mean control = 153, Mean intervention = 136, pooled SD = 25
SMD_from_mean(153, 136, 25)
}
\references{
https://handbook-5-1.cochrane.org/chapter_9/9_2_3_2_the_standardized_mean_difference.htm
}
