% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{datadir}
\alias{datadir}
\title{Return path to metabodecon's data directory}
\usage{
datadir(file = NULL, warn = TRUE, persistent = NULL)
}
\arguments{
\item{file}{Relative path to a file within the data directory.}

\item{warn}{Print a warning message when the requested path does not yet
exist?}

\item{persistent}{Return the path to the persistent data directory instead of
the temporary one?}
}
\value{
Path to the data directory or a file within it.
}
\description{
Returns the path to the directory where
\code{\link[=download_example_datasets]{download_example_datasets()}} stores metabodecon's example data sets or any
file within that directory. By default this directory is a subdirectory of
R's temporary session directory. If \code{persistent} is set to \code{TRUE}, the
directory equals the data directory returned by \code{\link[tools:userdir]{tools::R_user_dir()}}
instead.
}
\details{
The decision to use a temporary data dir as default and a persistent
one only optionally was made to conform to CRAN package policies, which state
that:

\emph{Packages should not write in the user's home filespace (including}
\emph{clipboards), nor anywhere else on the file system apart from the R}
\emph{session's temporary directory [...] Limited exceptions may be allowed}
\emph{in interactive sessions if the package obtains confirmation from the}
\emph{user. For R version 4.0 or later [...] packages may store user-specific}
\emph{data, configuration and cache files in their respective user directories}
\emph{obtained from \code{tools::R_user_dir()} [...].}

Source:
\href{https://cran.r-project.org/web/packages/policies.html}{cran.r-project.org/web/packages/policies}.
}
\examples{
# Get temporary datadir and persistent datadir
datadir(persistent = FALSE, warn = FALSE)
datadir(persistent = TRUE,  warn = FALSE)

# Get persistent datadir if existing else temp datadir. Set `warn = TRUE`
# to raise a warning if none of the directories exist yet.
datadir(warn = FALSE)
if (interactive()) datadir()

# Get PERSISTENT_DATADIR/bruker if existing else TEMP_DATADIR/bruker
datadir(file = "bruker/urine", warn = FALSE)
}
\seealso{
\code{\link[=download_example_datasets]{download_example_datasets()}},
\code{\link[=datadir_persistent]{datadir_persistent()}},
\code{\link[=datadir_temp]{datadir_temp()}}
}
\author{
2024-2025 Tobias Schmidt: initial version.
}
