#' metagroup: Meaningful Grouping of Studies in Meta-Analysis
#'
#' @description
#' The `metagroup` package provides a suite of tools to perform meaningful
#' subgrouping in a meta-analysis. This is a two-step process: first, use
#' the iterative grouping functions (e.g., `mgbin()`, `mgcont()`) to
#' partition studies into statistically homogeneous clusters. Second, use
#' the `meaning()` function to analyze these new subgroups and understand
#' their composition based on study-level characteristics (e.g., country,
#' setting).
#'
#' @author
#' Ahmed Abdelmageed \email{ahmedelsaeedmassad@@gmail.com}
#'
#' @seealso
#' Useful functions:
#' \itemize{
#'   \item \code{\link{mgbin}}, \code{\link{mgcont}}, \code{\link{mgcor}} for grouping studies.
#'   \item \code{\link{meaning}} for interpreting the new subgroups.
#' }
#'
#' @keywords package


"_PACKAGE"

NULL
