% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgcor.R
\name{mgcor}
\alias{mgcor}
\title{Group Studies with Correlation Data by Homogeneity}
\usage{
mgcor(data, cor, n, studlab, ...)
}
\arguments{
\item{data}{A data frame containing the meta-analysis data.}

\item{cor}{A vector of correlation coefficients.}

\item{n}{A vector of corresponding sample sizes.}

\item{studlab}{A vector of study labels.}

\item{...}{Additional arguments passed on to `meta::metacor`.}
}
\value{
A list containing the final data with subgroup assignments (`data`),
the final `metacor` model (`model`), and the number of attempts (`attempts`).
}
\description{
This function iteratively assigns studies to subgroups based on a homogeneity
test. The goal is to create statistically homogeneous groups of studies
before performing a final meta-analysis with correlation data.
}
\details{
The algorithm starts with a single study in "group 1". It then processes
each subsequent study, attempting to place it in an existing group. A study
is added to a group only if its inclusion does not result in significant
within-group heterogeneity. If no suitable group is found, a new one is created.
}
\seealso{
\code{\link{meaning}}
}
\author{
Ahmed Abdelmageed \email{ahmedelsaeedmassad@gmail.com}
}
